﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[FillerOrderNumberUpdate]') AND type in (N'P', N'PC'))
BEGIN 
	DROP PROCEDURE [hips].[FillerOrderNumberUpdate] 
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date:   13 October 2015
-- Description:   Updates a record into the FillerOrderNumber Table
-- =============================================
CREATE PROCEDURE [hips].[FillerOrderNumberUpdate] 
(
	@FillerOrderNumberId INT
	, @CdaSetNumberId INT
	, @FillerOrderNumber VARCHAR(256) = NULL
	, @OrderIdentifier VARCHAR(36) = NULL
	, @UserModified varchar(256)
	, @DateModified datetime
) AS
BEGIN
    SET NOCOUNT ON
	DECLARE @intErrorCode INT
    SET @intErrorCode = 0

    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[FillerOrderNumber]
				WHERE [FillerOrderNumberId] = @FillerOrderNumberId AND [DateModified] = @DateModified)
    BEGIN
		DECLARE @DateModifiedText NVARCHAR(30) 
		SET @DateModifiedText = CAST(@DateModified AS NVARCHAR)
		RAISERROR (50001, -1, -1, N'FillerOrderNumber', N'FillerOrderNumberId', @FillerOrderNumberId, N'DateModified', @DateModifiedText)
        SET @intErrorCode = @@ERROR
    END
	
	IF @intErrorCode = 0
    BEGIN
		UPDATE hips.FillerOrderNumber
		SET
				CdaSetNumberId = @CdaSetNumberId,
				FillerOrderNumber = @FillerOrderNumber,
				OrderIdentifier = @OrderIdentifier,
				DateModified = GETDATE(),
				UserModified = @UserModified
		WHERE   FillerOrderNumberId = @FillerOrderNumberId

		SELECT @intErrorCode = @@ERROR
	END

    IF @intErrorCode = 0
    BEGIN
        SELECT 
			FillerOrderNumberId,
			CdaSetNumberId,
			FillerOrderNumber,
			OrderIdentifier,
			DateCreated,
			UserCreated,
			DateModified,
			UserModified
		FROM  hips.FillerOrderNumber 
		WHERE FillerOrderNumberId = @FillerOrderNumberId
    END

    RETURN(@intErrorCode)
END
